/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import libsidutils.C64FontUtils;

public class CBMCodeUtils
extends C64FontUtils {
    private static final int[] PETSCII_TO_ISO8859_1 = new int[]{0, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 13, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 32, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 36, 93, 32, 32, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35, 45, 35, 124, 45, 45, 45, 45, 124, 124, 92, 92, 47, 92, 92, 47, 47, 92, 35, 95, 35, 124, 47, 88, 79, 35, 124, 35, 43, 124, 124, 38, 92, 32, 124, 35, 45, 45, 124, 35, 124, 35, 47, 124, 124, 47, 92, 92, 45, 47, 45, 45, 124, 124, 124, 124, 45, 45, 45, 47, 92, 92, 47, 47, 35};
    private static final int[] ISO8859_1_TO_SCREENRAM = new int[]{128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 27, 191, 29, 30, 100, 39, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 93, 29, 31, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 33, 3, 28, 191, 89, 93, 191, 34, 67, 1, 60, 191, 45, 82, 99, 15, 191, 50, 51, 39, 21, 191, 191, 44, 49, 15, 62, 191, 191, 191, 63, 65, 65, 65, 65, 65, 65, 65, 67, 69, 69, 69, 69, 73, 73, 73, 73, 191, 78, 79, 79, 79, 79, 79, 24, 79, 85, 85, 85, 85, 89, 191, 191, 1, 1, 1, 1, 1, 1, 1, 3, 5, 5, 5, 5, 9, 9, 9, 9, 191, 14, 15, 15, 15, 15, 15, 191, 15, 21, 21, 21, 21, 25, 191, 25};

    public static final String petsciiToIso88591(byte[] petscii) {
        StringBuilder result = new StringBuilder();
        for (byte b : petscii) {
            if (b == 0) break;
            result.append((char)PETSCII_TO_ISO8859_1[b & 0xFF]);
        }
        return result.toString();
    }

    public static final byte[] iso88591ToScreenRam(String iso, int maxLen) {
        byte[] result = new byte[Math.min(iso.length(), maxLen)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)ISO8859_1_TO_SCREENRAM[iso.charAt(i) & 0xFF];
        }
        return result;
    }

    public static final byte iso88591ToScreenRam(char iso) {
        return (byte)ISO8859_1_TO_SCREENRAM[iso & 0xFF];
    }

    public static final byte[] petsciiToScreenRam(String petscii) {
        byte[] result = new byte[petscii.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CBMCodeUtils.petsciiToScreenRam((byte)petscii.charAt(i));
        }
        return result;
    }

    public static byte petsciiToScreenRam(byte petscii) {
        int code = petscii & 0xFF;
        if (code < 31) {
            code += 128;
        } else if (code >= 63) {
            code = code < 95 ? (code -= 64) : (code < 127 ? (code -= 32) : (code < 159 ? (code += 64) : (code < 191 ? (code -= 64) : (code < 254 ? (code -= 128) : 94))));
        }
        return (byte)code;
    }
}

